##!/bin/bash
#!/usr/local/bin/bash
#zabbix API uploader
#Created By F.E.K.
#2021.01.19

declare -A zjsonconf
declare -A csoportok
declare -A templates
incomp=false
echo

sugo () {
 echo -e "\033[0;31mHiányos vagy hibás paraméter!\n\nAdd meg a feltöltés típusát\n\n  -s (switch)\n  -a (ap)\n  -h (agent Host deploy)\n\n és a feldogozandó állományt\033[0m\n\n"
 exit
}

igazitas () {
 igazitottkulcs=${kulcs// /}
 igazitottertek=$(echo $ertek|sed -e 's/^[ \t]*//')
}

 if [ ! -f z-json.conf ];then echo -e "\033[0;31mz-json.conf nem található!\033[0m\n";exit;fi
 if [ ! -f .zid ];then echo -e "\033[0;31mZID állomány nem található!\033[0m\n";exit;fi
 if [ ! -f $2 ];then echo -e "\033[0;31mFeldogozandó állomány nem található\033[0m: $2\n";exit;fi
 if [ -z "$2" ];then sugo;exit;fi

while IFS="=" read -r kulcs ertek
 do
 [[ "$line" =~ ^#.*$ ]] && continue
 igazitas
 if ! [ -z "$igazitottkulcs" ];then
	if [[ $igazitottkulcs == "debian_sysver" ]];then debian_sysver+=($igazitottertek);fi
	if [[ $igazitottkulcs == "os_type_ok" ]];then os_type_ok+=($igazitottertek);fi
        if [[ ! $igazitottkulcs =~ ^(debian_sysver|os_type_ok|groupid|templateid)$ ]];then zjsonconf[$igazitottkulcs]=$igazitottertek;fi
	if [[ $igazitottkulcs == "groupid" ]];then
        					groupid=($(echo $igazitottertek|awk -F, '{print $1}'))
                                		groupnev=($(echo $igazitottertek|awk -F, '{print $2}'))
                                		csoportok[$groupnev]=$groupid
        fi
        if [[ $igazitottkulcs == "templateid" ]];then
                                                templateid=($(echo $igazitottertek|awk -F, '{print $1}'))
                                                templatenev=($(echo $igazitottertek|awk -F, '{print $2}'))
                                                templates[$templatenev]=$templateid
        fi

 fi
done < <(sed -E '/^[[:blank:]]*$/d' z-json.conf)

log=${zjsonconf[logfile]}`date +"%Y-%m-%d_%H-%M"`.log
zpw=$(cat .zid)
jsondata="{\"jsonrpc\": \"2.0\", \"method\": \"user.login\",\"params\": { \"user\": \"${zjsonconf[user]}\", \"password\": \"$zpw\"}, \"id\": 1, \"auth\": null}"
zauth=$(curl -s --header "Content-Type: application/json" --request POST --data "$jsondata" https://${zjsonconf[zabbixhost]}${zjsonconf[api]}|awk -F, '{print $2}'|awk -F: '{print $2}')
gidn=$(echo  ${2^^}|awk -F_ '{print $2}'|awk -F. '{print $1}')
fejlec="{\"jsonrpc\": \"2.0\", \"method\": \"host.create\", \"params\": "
lezaro=",\"auth\": $zauth,\"id\": 1}"

json-switch () {
 sablon="{\"host\": \"XXXhostXXX\",
    \"interfaces\": [{
        \"type\": 2,
        \"main\": 1,
        \"useip\": 1,
        \"ip\": \"XXXoob_ipXXX\",
        \"dns\": \"\",
        \"port\": \"161\",
        \"details\": {
        \"version\": ${zjsonconf[version]},
        \"bulk\": ${zjsonconf[bulk]},
        \"securityname\": \"${zjsonconf[securityname]}\",
        \"securitylevel\": ${zjsonconf[securitylevel]},
        \"authprotocol\": ${zjsonconf[authprotocol]},
        \"authpassphrase\": \"${zjsonconf[authpassphrase]}\",
        \"privprotocol\": ${zjsonconf[privprotocol]},
        \"privpassphrase\": \"${zjsonconf[privpassphrase]}\",
        \"contextname\": \"\"
        }
    }],
    \"inventory_mode\": 1,
    \"description\": \"XXXdescriptionXXX\",
    \"groups\": [
        {\"groupid\": \"${csoportok[Network]}\"},
        {\"groupid\": \"${csoportok[Switch]}\"},
        {\"groupid\": \"${csoportok[$gidn]}\"}
                ],
    \"templates\": [
        {\"templateid\": \"${templates[Cisco_Total]}\"},
        {\"templateid\": \"${templates[Generic_SNMP]}\"},
        {\"templateid\": \"${templates[CiscoSwitchInterfaceSNMPv3]}\"},
        {\"templateid\": \"${templates[Cisco_Inventory_SNMP]}\"}
                   ]
    }"
}

json-ap () {
 sablon="{\"host\": \"XXXhostXXX\",
    \"interfaces\": [{
        \"type\": 1,
        \"main\": 1,
        \"useip\": 1,
        \"ip\": \"${zjsonconf[zabbixhostip]}\",
        \"dns\": \"${zjsonconf[zabbixhost]}\",
        \"port\": \"10050\"
    }],
      \"inventory_mode\": 0,
      \"inventory\": {
      \"macaddress_a\": \"XXXmacaddress_aXXX\",
      \"oob_ip\": \"XXXoob_ipXXX\",
      \"host_netmask\": \"XXXhost_netmaskXXX\",
      \"host_router\": \"XXXhost_routerXXX\",
      \"location\": \"XXXlocationXXX\",
      \"notes\": \"XXXnotesXXX\",
      \"serialno_a\": \"XXXserialno_aXXX\",
      \"type\": \"XXXtypeXXX\",
      \"type_full\": \"XXXtype_fullXXX\"
                    },
      \"groups\": [
      {\"groupid\": \"${csoportok[Network]}\"},
      {\"groupid\": \"${csoportok[AP]}\"},
      {\"groupid\": \"${csoportok[$gidn]}\"}
   ],
    \"templates\": [{
        \"templateid\": \"${templates[ApCheck_Template]}\"
    }]
    }"
}

json-agent () {
 sablon="{\"host\": \"XXXhostXXX\",
    \"interfaces\": [{
        \"type\": 1,
        \"main\": 1,
        \"useip\": 0,
        \"ip\": \"XXXoob_ipXXX\",
        \"dns\": \"XXXhostXXX\",
        \"port\": \"10050\"
    }],
      \"groups\": [
      {\"groupid\": \"2\"}
   ],
    \"tls_connect\": 2,
    \"tls_accept\": 2,
    \"tls_psk\": \"XXXpskeyXXX\",
    \"tls_psk_identity\": \"XXXhostXXX\",
    \"templates\": [{
    \"templateid\": \"${templates[Linux_by_Zabbix_agent_active]}\"
    }]
    }"
}

agentdeploy () {
 agenthost=$(echo "$line"|awk -F\; '{print $1}')
 agentcel="${zjsonconf[agentuser]}@$agenthost"
 ostype=$(ssh -n $agentcel -T "lsb_release -i"|awk -F: '{print $2}'|awk '{print $1}')
 sysver=$(ssh -n $agentcel -T "lsb_release -r"|awk '{print $2}'|awk -F. '{print $1}')
 sysagentver=$(ssh -n $agentcel "zabbix_agent2 -V >/dev/null 2>&1;if [ $? = 0 ];then zabbix_agent2 -V| sed 1q|awk '{print $3}';fi" 2> /dev/null)
 echo -e "\nHost: $agenthost, OS: $ostype, System: $sysver"|tee -a $log
  if ([[ ! " ${os_type_ok[@]} " =~ " $ostype " ]] || [[ ! " ${debian_sysver[@]} " =~ " $sysver " ]]);then incomp=true;echo "Nem kompatibilis rendszer."|tee -a $log;fi
  if [[ $sysagentver ]];then incomp=true;echo -e "Agent már telepítve: $sysagentver"|tee -a $log;fi
  if ! $incomp;then
    echo -e "\nAgent telepítése folyamatban..."|tee -a $log
    pskey=$(openssl rand -hex 64)
#    ssh -n $agentcel -T "apt-get -y install wget"|tee -a $log
    ssh -n $agentcel -T "apt-get -y --force-yes install apt-transport-https debian-keyring debian-archive-keyring"|tee -a $log
    ssh -n $agentcel -T "wget http://repo.zabbix.com/zabbix/${zjsonconf[agentver]}/debian/pool/main/z/zabbix-release/zabbix-release_${zjsonconf[agentver]}-1+debian\"$sysver\"_all.deb -P /tmp"|tee -a $log
    ssh -n $agentcel -T "yes | dpkg -i /tmp/./zabbix-release_${zjsonconf[agentver]}-1+debian\"$sysver\"_all.deb;sed -i 's/https/http/' /etc/apt/sources.list.d/zabbix.list"|tee -a $log
    ssh -n $agentcel -T "rm /tmp/zabbix-release_${zjsonconf[agentver]}-1+debian\"$sysver\"_all.deb;apt-get update && apt-get -y install zabbix-agent2"|tee -a $log
    ssh -n $agentcel -T "echo $pskey>${zjsonconf[confdir]}/zabbix.psk"
    ssh -n $agentcel -T "sed -i -e 's/^Server=127.0.0.1/Server=${zjsonconf[zabbixhost]}/' -e 's/^ServerActive=127.0.0.1/ServerActive=${zjsonconf[zabbixhost]}/' -e 's/^Hostname=Zabbix server/Hostname=$agenthost/' ${zjsonconf[confdir]}/${zjsonconf[confile]}"|tee -a $log
    ssh -n $agentcel -T "echo -e \"TLSConnect=psk\nTLSAccept=psk\nTLSPSKFile=${zjsonconf[confdir]}/zabbix.psk\nTLSPSKIdentity=$agenthost\n\">>${zjsonconf[confdir]}/${zjsonconf[confile]}"|tee -a $log
    ssh -n $agentcel -T "service zabbix-agent2 restart;service zabbix-agent2 status"|tee -a $log
    ures=${ures//XXXpskeyXXX/$pskey}
  fi
}

feldolgozas () {
 echo -e "${zjsonconf[ver]}, Zabbix API upload indítva: $(date)\nMód: -$kapcsolo ($mod), file: $OPTARG\n"|tee $log
 while IFS='' read -r line || [[ "$line" ]]
    do
     [[ "$line" =~ ^#.*$ ]] && continue
     incomp=false
     ures=$(echo $sablon)
      if [ $mod == "Host" ];then agentdeploy;fi
      if ! $incomp;then
         mszam=1
         for m in $sablonok
            do
             ures=${ures//XXX${m}XXX/$(echo "$line"|awk -F\; -v mezo="$mszam" '{print $mezo}')}
              ((mszam++))
            done
         jsonput=$(echo $fejlec$ures$lezaro)
         echo -e "\n$jsonput\n"|tee -a $log
         logger=$(curl -s --header "Content-Type: application/json" --request POST --data "$jsonput" https://${zjsonconf[zabbixhost]}/${zjsonconf[api]})
         echo $logger|tee -a $log
     fi
  done < <(sed -E '/^[[:blank:]]*$/d; /^[[:blank:]]+#/d' "$OPTARG")
}

lefutott () {
 echo -e "\nLefutott: $(date)\n"|tee -a $log
 exit
}

while getopts ":s:a:h:" kapcsolo
do
    case "${kapcsolo}" in
      s) sablonok="host oob_ip description"
           json-switch
	   mod="Switch"
	   feldolgozas
      ;;
      a) sablonok="host macaddress_a oob_ip host_netmask host_router location notes serialno_a type type_full"
           json-ap
	   mod="AP"
	   feldolgozas
      ;;
      h) sablonok="host oob_ip"
           json-agent
           mod="Host"
	   feldolgozas
      ;;
    esac
done

 if [[ -z "$sablonok" ]];then sugo;fi

lefutott

